/*
 * Decompiled with CFR 0.152.
 */
package de.company.filenet.importer;

import com.filenet.api.collection.ContentElementList;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.property.Properties;
import com.filenet.api.util.UserContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.NodeList;

public class FileNetImporter {
    private static final Logger LOG = Logger.getLogger(FileNetImporter.class.getName());
    private String ceUri;
    private String username;
    private String password;
    private String stanza;
    private String objectStoreName;
    private String sourceFolderPath;
    private boolean recursive;
    private Set<String> allowedExtensions;
    private String documentClass;
    private String targetFolderPath;
    private String checkinState;
    private String mimeTypeMode;
    private String logFile;
    private String doneFolderPath;
    private String errorFolderPath;

    public static void main(String[] args) {
        String configPath = args.length > 0 ? args[0] : "config.xml";
        FileNetImporter importer = new FileNetImporter();
        try {
            importer.loadConfig(configPath);
            importer.setupLogging();
            importer.run();
        }
        catch (Exception e) {
            System.err.println("Fehler beim Import: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadConfig(String configPath) throws Exception {
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            throw new FileNotFoundException("Konfigurationsdatei nicht gefunden: " + configPath);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc = builder.parse(configFile);
        doc.getDocumentElement().normalize();
        this.ceUri = this.getTextContent(doc, "ce-uri");
        this.username = this.getTextContent(doc, "username");
        this.password = this.getTextContent(doc, "password");
        this.stanza = this.getTextContent(doc, "stanza");
        this.objectStoreName = this.getTextContent(doc, "name");
        this.sourceFolderPath = this.getTextContent(doc, "source-folder");
        this.recursive = Boolean.parseBoolean(this.getTextContent(doc, "recursive"));
        this.documentClass = this.getTextContent(doc, "document-class");
        this.targetFolderPath = this.getTextContent(doc, "target-folder");
        this.checkinState = this.getTextContent(doc, "checkin-state");
        this.mimeTypeMode = this.getTextContent(doc, "mime-type");
        this.logFile = this.getTextContent(doc, "log-file");
        this.doneFolderPath = this.getTextContent(doc, "done-folder");
        this.errorFolderPath = this.getTextContent(doc, "error-folder");
        String extRaw = this.getTextContent(doc, "file-extensions");
        this.allowedExtensions = new HashSet<String>();
        if (extRaw != null && !extRaw.trim().isEmpty()) {
            for (String ext : extRaw.split(",")) {
                this.allowedExtensions.add(ext.trim().toLowerCase());
            }
        }
    }

    private String getTextContent(org.w3c.dom.Document doc, String tagName) {
        NodeList nodes = doc.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent().trim();
        }
        return "";
    }

    private void setupLogging() throws IOException {
        FileHandler fileHandler = new FileHandler(this.logFile, true);
        fileHandler.setFormatter(new SimpleFormatter(){
            private static final String FORMAT = "[%1$tF %1$tT] [%2$s] %3$s %n";

            @Override
            public synchronized String format(LogRecord lr) {
                return String.format(FORMAT, new Date(lr.getMillis()), lr.getLevel().getLocalizedName(), lr.getMessage());
            }
        });
        LOG.addHandler(fileHandler);
        LOG.setLevel(Level.INFO);
        LOG.info("=== FileNet Importer gestartet ===");
        LOG.info("Quelle      : " + this.sourceFolderPath);
        LOG.info("Done-Ordner : " + this.doneFolderPath);
        LOG.info("Error-Ordner: " + this.errorFolderPath);
        LOG.info("CE-URI      : " + this.ceUri);
        LOG.info("Object Store: " + this.objectStoreName);
        LOG.info("FN-Ordner   : " + this.targetFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        List<File> files = this.collectFiles(new File(this.sourceFolderPath));
        if (files.isEmpty()) {
            LOG.info("Keine Dateien zum Importieren gefunden.");
            return;
        }
        LOG.info("Gefundene Dateien: " + files.size());
        File doneFolder = this.ensureLocalFolder(this.doneFolderPath);
        File errorFolder = this.ensureLocalFolder(this.errorFolderPath);
        Connection connection = Factory.Connection.getConnection((String)this.ceUri);
        Subject subject = UserContext.createSubject((Connection)connection, (String)this.username, (String)this.password, (String)this.stanza);
        UserContext.get().pushSubject(subject);
        try {
            Domain domain = Factory.Domain.fetchInstance((Connection)connection, null, null);
            ObjectStore os = Factory.ObjectStore.fetchInstance((Domain)domain, (String)this.objectStoreName, null);
            LOG.info("Verbunden mit Object Store: " + os.get_DisplayName());
            Folder targetFolder = this.getOrCreateFolder(os, this.targetFolderPath);
            int success = 0;
            int failed = 0;
            for (File file : files) {
                try {
                    this.importDocument(os, targetFolder, file);
                    this.moveFile(file, doneFolder);
                    ++success;
                    LOG.info("[OK]     " + file.getName() + "  ->  done");
                }
                catch (Exception e) {
                    this.moveFile(file, errorFolder);
                    ++failed;
                    LOG.severe("[FEHLER] " + file.getName() + "  ->  error | " + e.getMessage());
                }
            }
            LOG.info("=== Import abgeschlossen: " + success + " OK, " + failed + " Fehler ===");
        }
        finally {
            UserContext.get().popSubject();
        }
    }

    private File ensureLocalFolder(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            if (folder.mkdirs()) {
                LOG.info("Lokaler Ordner angelegt: " + folder.getAbsolutePath());
            } else {
                LOG.warning("Lokaler Ordner konnte nicht angelegt werden: " + folder.getAbsolutePath());
            }
        }
        return folder;
    }

    private void moveFile(File file, File targetDir) {
        File dest = new File(targetDir, file.getName());
        if (dest.exists()) {
            String ts = new SimpleDateFormat("yyyyMMdd_HHmmssSSS").format(new Date());
            String name = file.getName();
            int dot = name.lastIndexOf(46);
            String newName = dot >= 0 ? name.substring(0, dot) + "_" + ts + name.substring(dot) : name + "_" + ts;
            dest = new File(targetDir, newName);
        }
        if (!file.renameTo(dest)) {
            LOG.warning("Datei konnte nicht verschoben werden: " + file.getName() + " -> " + dest.getAbsolutePath());
        }
    }

    private List<File> collectFiles(File folder) {
        ArrayList<File> result = new ArrayList<File>();
        if (!folder.exists() || !folder.isDirectory()) {
            LOG.warning("Quellordner existiert nicht oder ist kein Verzeichnis: " + folder.getAbsolutePath());
            return result;
        }
        File[] entries = folder.listFiles();
        if (entries == null) {
            return result;
        }
        for (File f : entries) {
            if (f.isFile()) {
                if (!this.isAllowed(f)) continue;
                result.add(f);
                continue;
            }
            if (!f.isDirectory() || !this.recursive) continue;
            result.addAll(this.collectFiles(f));
        }
        return result;
    }

    private boolean isAllowed(File f) {
        if (this.allowedExtensions.isEmpty()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return false;
        }
        return this.allowedExtensions.contains(name.substring(dot + 1));
    }

    private Folder getOrCreateFolder(ObjectStore os, String folderPath) {
        try {
            return Factory.Folder.fetchInstance((ObjectStore)os, (String)folderPath, null);
        }
        catch (Exception e) {
            LOG.info("Zielordner nicht gefunden, wird angelegt: " + folderPath);
            return this.createFolderPath(os, folderPath);
        }
    }

    private Folder createFolderPath(ObjectStore os, String folderPath) {
        String[] parts = folderPath.split("/");
        Folder current = Factory.Folder.fetchInstance((ObjectStore)os, (String)"/", null);
        StringBuilder currentPath = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            currentPath.append("/").append(part);
            try {
                current = Factory.Folder.fetchInstance((ObjectStore)os, (String)currentPath.toString(), null);
            }
            catch (Exception e) {
                Folder newFolder = Factory.Folder.createInstance((ObjectStore)os, null);
                newFolder.set_FolderName(part);
                newFolder.set_Parent(current);
                newFolder.save(RefreshMode.NO_REFRESH);
                current = Factory.Folder.fetchInstance((ObjectStore)os, (String)currentPath.toString(), null);
            }
        }
        return current;
    }

    private void importDocument(ObjectStore os, Folder targetFolder, File file) throws Exception {
        String mimeType;
        String documentTitle = file.getName();
        if ("auto".equalsIgnoreCase(this.mimeTypeMode) || this.mimeTypeMode.isEmpty()) {
            mimeType = URLConnection.guessContentTypeFromName(file.getName());
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
        } else {
            mimeType = this.mimeTypeMode;
        }
        Document doc = Factory.Document.createInstance((ObjectStore)os, (String)this.documentClass);
        Properties props = doc.getProperties();
        props.putValue("DocumentTitle", documentTitle);
        ContentElementList contentList = Factory.ContentElement.createList();
        ContentTransfer ct = Factory.ContentTransfer.createInstance();
        ct.setCaptureSource((InputStream)new FileInputStream(file));
        ct.set_ContentType(mimeType);
        ct.set_RetrievalName(file.getName());
        contentList.add((Object)ct);
        doc.set_ContentElements(contentList);
        doc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        doc.save(RefreshMode.NO_REFRESH);
        ReferentialContainmentRelationship rcr = targetFolder.file((IndependentlyPersistableObject)doc, AutoUniqueName.AUTO_UNIQUE, documentTitle, DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
        rcr.save(RefreshMode.NO_REFRESH);
    }
}

