# FileNet P8 5.7 – Dokument-Importer

Importiert Dateien aus einem lokalen Ordner in einen FileNet P8 Object Store  
und schreibt den Dateinamen in das Property **DocumentTitle** der Dokumentklasse.

---

## Projektstruktur

```
filenet-import/
├── config.xml                          ← Konfigurationsdatei (alle Parameter)
├── pom.xml                             ← Maven Build-Datei
├── lib/                                ← FileNet JARs (manuell befüllen, s. u.)
│   ├── Jace.jar
│   ├── javaapi.jar
│   └── pe.jar
└── src/
    └── main/java/de/company/filenet/importer/
        └── FileNetImporter.java        ← Hauptklasse
```

---

## 1. Voraussetzungen

| Was | Version |
|-----|---------|
| Java JDK | 11 oder 17 |
| Maven | 3.6+ |
| FileNet P8 | 5.7 |
| Netzwerkzugang zum CE-Server | – |

---

## 2. FileNet JARs bereitstellen

Die API-JARs sind **nicht** im Maven Central verfügbar und müssen manuell  
aus dem Content Engine-Installationsverzeichnis kopiert werden:

```bash
# Typischer Pfad auf dem CE-Server:
# /opt/IBM/FileNet/ContentEngine/lib/

# In den lib/-Ordner des Projekts kopieren:
mkdir -p lib
cp /opt/IBM/FileNet/ContentEngine/lib/Jace.jar    lib/
cp /opt/IBM/FileNet/ContentEngine/lib/javaapi.jar lib/
cp /opt/IBM/FileNet/ContentEngine/lib/pe.jar      lib/
```

---

## 3. Konfiguration (config.xml)

Alle Parameter werden in **config.xml** gepflegt:

| Element | Beschreibung | Beispiel |
|---------|-------------|---------|
| `<ce-uri>` | MTOM-URL des Content Engine WSI | `http://myserver:9080/wsi/FNCEWS40MTOM/` |
| `<username>` | Benutzer für FileNet | `p8admin` |
| `<password>` | Passwort | `geheim` |
| `<stanza>` | JAAS-Stanza | `FileNetP8` |
| `<n>` (unter `<object-store>`) | Name des Object Stores | `TARGET_OS` |
| `<source-folder>` | Lokaler Importordner | `C:/import/docs` |
| `<recursive>` | Unterordner einbeziehen | `true` / `false` |
| `<file-extensions>` | Erlaubte Dateitypen (leer = alle) | `pdf,docx,tif` |
| `<document-class>` | FileNet Dokumentklasse | `Document` |
| `<target-folder>` | Zielordner im Object Store | `/ImportedDocuments` |
| `<checkin-state>` | Checkin-Status | `RELEASED` |
| `<mime-type>` | MIME-Type-Ermittlung | `auto` oder `application/pdf` |
| `<log-file>` | Pfad zur Logdatei | `filenet-import.log` |

---

## 4. Build

```bash
mvn clean package
```

Das Fat-JAR wird erstellt unter:  
`target/filenet-importer-1.0.0-jar-with-dependencies.jar`

---

## 5. Ausführen

```bash
java -jar target/filenet-importer-1.0.0-jar-with-dependencies.jar config.xml
```

Oder mit explizitem Classpath (ohne Maven Assembly):

```bash
java -cp "target/filenet-importer-1.0.0.jar:lib/*" \
     de.company.filenet.importer.FileNetImporter config.xml
```

---

## 6. Ablauf des Imports

1. Alle erlaubten Dateien im Quellordner werden gesammelt.
2. Eine FileNet-Verbindung wird mit den konfigurierten Credentials aufgebaut.
3. Der Zielordner wird geprüft; fehlt er, wird er automatisch angelegt.
4. Für jede Datei wird ein Dokument der konfigurierten Klasse erstellt:
   - `DocumentTitle` = Dateiname (mit Extension)
   - Primärinhalt = Dateiinhalt
   - MIME-Type = automatisch oder aus Konfiguration
5. Das Dokument wird in den Zielordner abgelegt (Checkin: Major Version).
6. Ergebnisse werden in die Logdatei geschrieben.

---

## 7. Hinweise

- **Passwort-Sicherheit**: Für Produktivumgebungen empfiehlt sich das Auslagern  
  des Passworts in eine Umgebungsvariable oder einen Secret-Manager.
- **Doppelter Import**: Das Programm prüft nicht, ob eine Datei bereits importiert  
  wurde. Wiederholte Ausführung erzeugt Duplikate.
- **JAAS**: Die Datei `jaas.conf` muss beim Start ggf. als System-Property  
  übergeben werden:  
  ```bash
  java -Djava.security.auth.login.config=jaas.conf -jar ...
  ```
